<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
header('Access-Control-Allow-Origin: *');
class Homepage extends CI_Controller {

    function __construct(){
        ini_set('display_errors', 1);
        parent::__construct();
        $this->load->library('session','form_validation');
        $this->load->helper('url');
        $this->load->helper('form');
        $this->load->helper('file');
        $this->load->helper('download');
        $this->load->model('homem', 'home');
    }

    public function index()
    {	
        echo "Welcome to Bloom Pharmacy Custom App";die;
    }

    public function soap_to_json()
    {
        
        // SELECT id,item_code, COUNT(item_code) FROM erp_response GROUP BY item_code HAVING COUNT(item_code) > 1; 

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'http://197.44.55.68/bloom_onlinestore_ws/n_bloom_onlinestore_ws.asmx?op=f_get_items_list',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'<?xml version="1.0" encoding="utf-8"?>
        <soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
          <soap12:Body>
            <f_get_items_list xmlns="http://tempurl.org">
              <str1>
                <str_items_list>
                  <item_code>34543</item_code>
                </str_items_list>
                <str_items_list>
                  <item_code>34543</item_code>
                </str_items_list>
              </str1>
            </f_get_items_list>
          </soap12:Body>
        </soap12:Envelope>',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/soap+xml',
            'Host: 197.44.55.68',
            'User-Agent: PostmanRuntime/7.32.2',
            'Accept: */*',
            'Accept-Encoding: gzip, deflate, br',
            'Connection: keep-alive',
            'Cookie: PowerBuilder=CurrentTheme=xp'
          ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        // $xml = file_get_contents($response);
        // SimpleXML seems to have problems with the colon ":" in the <xxx:yyy> response tags, so take them out
        $xml = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $response);
        // echo "<pre>";print_r($xml);die;
        $xml = simplexml_load_string($xml);
        $json = json_encode($xml);
        $responseArray = json_decode($json,true);
        // echo "<pre>";print_r($responseArray['soapBody']['f_get_items_listResponse']['str1']['str_items_list']);die;
        $array = $responseArray['soapBody']['f_get_items_listResponse']['str1']['str_items_list'];
        
        // ADDING JSON DATA INTO DATABASE 
        $json_data = array(

            'json_data'  => json_encode($array)
        ); 
        
        //echo "<pre>";print_r($array);die;
        $json_insert = $this->home->insert('erp_xml_response',$json_data);
        
        //send email 
//         $body = '';
//         $body .= 'test email from bloom pharmacy';
        
//         $config = array(
// 				 'protocol' => 'mail', // 'mail', 'sendmail', or 'smtp'
// 				 'smtp_host' => 'smtp.gmail.com', 
// 				 'smtp_port' => 465,
// 				 'smtp_crypto' => 'ssl',
// 				 'smtp_user' => 'mattin.h@edreamz.in',
// 				 'smtp_pass' => 'Mattin@2020',
// 				 'mailtype' => 'html', //plaintext 'text' mails or 'html'
// 				 'charset' => 'utf-8',
				 
// 			);
				
// 			$this->load->library('email', $config);
// 			$this->email->set_newline("\r\n");
	       
			
// 	        $from = "kiran.k@edreamz.in";
	  	    
			
// 			$subject = "Test email from bloom pharmacy soap to JSON";
// 			$this->email->from($from);
// 			$this->email->to('megha.m@edreamz.in');
// 			$this->email->bcc('kiran.k@edreamz.in');
// 			$this->email->subject($subject);
// 			$this->email->message($body);
// 			$this->email->send();

        for ($i=0; $i < sizeof($array); $i++) 
        {
            
            $where = 'erp_response.'."item_code = '".intval($array[$i]['item_code'])."'";

            $dataExists=$this->home->getRowByWhere('erp_response',$where);
            
            if($dataExists)
            {
                
                $data3 = array(

                'item_code'  => $array[$i]['item_code'],
                'item_barcode'  => $array[$i]['item_international_barcode'],
                'quantity' => $array[$i]['item_total_balance_qty'],
                'previous_quantity' => $dataExists->previous_quantity,
                'sell_price' => $array[$i]['item_enduser_sellprice'],
                'previous_sell_price' => $dataExists->previous_sell_price,
                'compare_price' => $array[$i]['item_unit_cost'],
                'previous_compare_price' => $dataExists->previous_compare_price
                );
                
                $where1 = 'erp_response.'."item_code = '".$array[$i]['item_code']."'";
                $update = $this->home->update('erp_response',$data3,$where1);
                
                // $update_ids[] = $update;
                echo $update; 

            }
            else
            {
                
                $data1 = array(

                'item_code'  => $array[$i]['item_code'],
                'item_barcode'  => $array[$i]['item_international_barcode'],
                'quantity' => $array[$i]['item_total_balance_qty'],
                'previous_quantity' => $array[$i]['item_total_balance_qty'],
                'sell_price' => $array[$i]['item_enduser_sellprice'],
                'previous_sell_price' => 0,
                'compare_price' => $array[$i]['item_unit_cost'],
                'previous_compare_price' => 0
                );
                
                $insert = $this->home->insert('erp_response',$data1);
                
                // $insert_ids[] = $insert;
                echo $insert;
            }
            
        }
        
        
    }
    
    public function erp_to_database()
    {
        $xml_response = $this->home->getXMLResponse();
        
        // echo "<pre>";print_r(json_decode($xml_response['json_data']));die;
        
        if($xml_response)
        {   
            
            // echo "<pre>";print_r(json_decode($xml_response['json_data']));die;
            
            $this->db->select('*');
            $this->db->from('erp_response');
            $q = $this->db->get();
            $erp_response = $q->result_array();
            
            echo "<pre>";print_r($erp_response);die;
            
            $xml_json_response = json_decode($xml_response['json_data']);
            
            $results = array_filter($xml_json_response, function($xml_json_response) {
              return $xml_json_response->item_code == 7355;
            });
            
            echo "<pre>";print_r($results);die;
            
            foreach($xml_json_response as $response) 
            {
                // echo "<pre>";print_r($response);
                
                // // $where = 'erp_response.'."item_code = '".intval($response->item_code)."'";
    
                // // $dataExists=$this->home->getRowByWhere('erp_response',$where);
                
                // $this->db->select('*');
                // $this->db->from('erp_response');
                // $this->db->where('item_code', intval($response->item_code));
                // $this->db->where('updated_by_erp !=', date("Y-m-d"));
                // $q = $this->db->get();
                // $dataExists = $q->row();
    
                // echo "<pre>";print_r($dataExists);
             
                // if($dataExists)
                // {
                //     echo "<pre>";print_r($response->item_code);    
                    
                //     // $data3 = array(
    
                //     // 'item_code'  => $response->item_code,
                //     // 'item_barcode'  => $response->item_international_barcode,
                //     // 'quantity' => $response->item_total_balance_qty,
                //     // 'previous_quantity' => $dataExists->previous_quantity,
                //     // 'sell_price' => $response->item_enduser_sellprice,
                //     // 'previous_sell_price' => $dataExists->previous_sell_price,
                //     // 'compare_price' => $response->item_unit_cost,
                //     // 'previous_compare_price' => $dataExists->previous_compare_price
                //     // );
                    
                //     // $where1 = 'erp_response.'."item_code = '".intval($response->item_code)."'";
                //     // $update = $this->home->update('erp_response',$data3,$where1);
                    
                //     // echo $update; 
                    
                //     $this->db->set('item_code',$response->item_code);
                //     $this->db->set('item_barcode',$response->item_international_barcode);
                //     $this->db->set('quantity',$response->item_total_balance_qty);
                //     $this->db->set('previous_quantity',$dataExists->previous_quantity);
                //     $this->db->set('sell_price',$response->item_enduser_sellprice);
                //     $this->db->set('previous_sell_price',$dataExists->previous_sell_price);
                //     $this->db->set('compare_price',$response->item_unit_cost);
                //     $this->db->set('previous_compare_price',$dataExists->previous_compare_price);
                //     $this->db->set('updated_by_erp',date('Y-m-d'));
                    
                    
                //     $this->db->where('item_code',intval($response->item_code));
                //     $this->db->update('erp_response');
    
                // }
                // else
                // {
                //     echo "ITEM CODE NOT EXIST : ".$response->item_code;    
                    
                //     // $data1 = array(
    
                //     // 'item_code'  => $response->item_code,
                //     // 'item_barcode'  => $response->item_international_barcode,
                //     // 'quantity' => $response->item_total_balance_qty,
                //     // 'previous_quantity' => $response->item_total_balance_qty,
                //     // 'sell_price' => $response->item_enduser_sellprice,
                //     // 'previous_sell_price' => 0,
                //     // 'compare_price' => $response->item_unit_cost,
                //     // 'previous_compare_price' => 0
                //     // );
                    
                //     // $insert = $this->home->insert('erp_response',$data1);
                //     // echo $insert;
                // }
                
            }
        }
    }
    
    public function insertProducts()
    {
        $shop = "65994c.myshopify.com";
        $getStore = $this->home->getStore($shop);
        $token = $getStore->token;

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);

        $this->load->library('shopifyapi', $params);

        try {
            $product_count = $this->shopifyapi->call('GET', '/admin/api/2023-01/products/count.json');
                   
                if ($product_count > 0) {
                    $all_products = [];
                    $last_id = '';
                    do {
                        $products = $this->shopifyapi->call('GET', '/admin/api/2023-01/products.json?limit=250&since_id='.$last_id.'&order=id%20asc');
                        $all_products = array_merge($all_products, $products);
                        if (count($products)>0) {
                            $last_product_id = end($products);
                            $last_id = $last_product_id['id'];
                        }
                        
                    } while (!empty($products));
                
                }
                
            } catch (ShopifyApiException $e) {
                // pre($e);exit;
            }
    
        // echo "<pre>";print_r($all_products);die;
        foreach($all_products as $product)
        {
            echo "<pre>";print_r($product['title']);
            for($i = 0; $i < sizeof($product['variants']); $i++)
            {
                $data1 = array(

                    'product_id'  => $product['id'],
                    'variant_id'  => $product['variants'][$i]['id'],
                    'inventory_item_id' => $product['variants'][$i]['inventory_item_id'],
                    'item_barcode' => $product['variants'][$i]['barcode']
                );  

                $where = 'products.'."variant_id = '".$product['variants'][$i]['id']."'";

                $dataExists=$this->home->getRowByWhere('products',$where);

                // echo "<pre>";print_r($dataExists);

                if($dataExists)
                {
                    $where1 = 'products.'."variant_id = '".$product['variants'][$i]['id']."'";
                    $update = $this->home->update('products',$data1,$where1);

                    echo $update; 

                }
                else
                {
                    $insert = $this->home->insert('products',$data1);

                    echo $insert;
                }

            }
        }
    }
    
    public function insertLatestProducts()
    {
        $shop = "65994c.myshopify.com";
        $getStore = $this->home->getStore($shop);
        $token = $getStore->token;

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);

        $this->load->library('shopifyapi', $params);

        try {
            $product_count = $this->shopifyapi->call('GET', '/admin/api/2023-01/products/count.json');
                   
                if ($product_count > 0) {
                    $all_products = [];
                    $last_id = '';
                    do {
                        $products = $this->shopifyapi->call('GET', '/admin/api/2023-01/products.json?limit=250&since_id='.$last_id.'&order=id%20desc');
                        $all_products = array_merge($all_products, $products);
                        if (count($products)>0) {
                            $last_product_id = end($products);
                            $last_id = $last_product_id['id'];
                        }
                        
                    } while (!empty($products));
                
                }
                
            } catch (ShopifyApiException $e) {
                // pre($e);exit;
            }
    
        // echo "<pre>";print_r($all_products);die;
        foreach($all_products as $product)
        {
            echo "<pre>";print_r($product['title']);
            for($i = 0; $i < sizeof($product['variants']); $i++)
            {
                $data1 = array(

                    'product_id'  => $product['id'],
                    'variant_id'  => $product['variants'][$i]['id'],
                    'inventory_item_id' => $product['variants'][$i]['inventory_item_id'],
                    'item_barcode' => $product['variants'][$i]['barcode']
                );  

                $where = 'products.'."variant_id = '".$product['variants'][$i]['id']."'";

                $dataExists=$this->home->getRowByWhere('products',$where);

                // echo "<pre>";print_r($dataExists);

                if($dataExists)
                {
                    $where1 = 'products.'."variant_id = '".$product['variants'][$i]['id']."'";
                    $update = $this->home->update('products',$data1,$where1);

                    echo $update; 

                }
                else
                {
                    $insert = $this->home->insert('products',$data1);

                    echo $insert;
                }

            }
        }
    }
    
    public function updateProductsOld()
    {

        $shop = "65994c.myshopify.com";
        $getStore = $this->home->getStore($shop);
        $token = $getStore->token;

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);

        $this->load->library('shopifyapi', $params);


        $this->db->select('*');
        $this->db->from('erp_response');
        $this->db->where('updated_on_cron !=', date("Y-m-d"));
        // $this->db->join('products', 'erp_response.item_code = products.item_barcode', 'inner');
        $q = $this->db->get();
        $result = $q->result_array();
        // echo date('Y-m-d');die;
        echo "<pre>";print_r($result);exit;
        if(!empty($result)) 
        {
            foreach($result as $erp)    
            {
                $where = 'products.'."item_barcode = '".$erp['item_code']."'";
                $product = $this->home->getRowByWhere('products',$where);
                
                if(!empty($product))
                {
                    // echo "<pre>";print_r($erp['item_code']);
                    // echo "<pre>";print_r($product);
                    // echo "<pre>";print_r(intval($erp['quantity']));
                    // echo "<pre>";print_r(number_format((float)$erp['sell_price'], 2, '.', ''));
                    // echo "<pre>";print_r(number_format((float)$erp['compare_price'], 2, '.', ''));
                        
                    if(number_format((float)$erp['sell_price'], 2, '.', '') == number_format((float)$erp['previous_sell_price'], 2, '.', ''))
                    {
                        // echo "PRICES ARE SAME";
                        
                        // if(intval($erp['previous_quantity']) != intval($erp['quantity']))
                        // {
                        //     $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));
                            
                        //     //update previuos qty and cron date
                        //     $this->db->set('previous_quantity',$erp['quantity']);
                        //     $this->db->set('updated_on_cron',date('Y-m-d'));
                        //     $this->db->where('id',$erp['id']);
                        //     $this->db->update('erp_response');
                        // }
                        $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));
                        
                        //update previuos qty and cron date
                            // $this->db->set('previous_quantity',$erp['quantity']);
                        $this->db->set('updated_on_cron',date('Y-m-d'));
                        $this->db->where('id',$erp['id']);
                        $this->db->update('erp_response');
                    }
                    else
                    {
                        // echo "PRICES ARE NOT SAME";
                            // echo "<pre>";print_r($product->variant_id);
                        
                            // echo "<pre>";print_r(number_format((float)$erp['sell_price'], 2, '.', ''));
                            
                            // echo "<pre>";print_r($variant_data['price']);
                            
                        $product_array = array(
                    
                            "variant" => array(

                                "id" => $product->variant_id,
                                "price" =>  number_format((float)$erp['sell_price'], 2, '.', ''),
                                "cost" => number_format((float)$erp['compare_price'], 2, '.', '')
                                )
                        );
                        // echo "<pre>";print_r($product_array);die;
                        try {

                            $update = $this->shopifyapi->call('PUT', '/admin/api/2023-10/variants/'.$product->variant_id.'.json',$product_array);

                            if($update)
                            {
                                // if(intval($erp['previous_quantity']) != intval($erp['quantity']))
                                // {
                                //     $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));
                                    
                                //     //update previuos qty and cron date
                                //     $this->db->set('previous_quantity',$erp['quantity']);
                                //     $this->db->where('id',$erp['id']);
                                //     $this->db->update('erp_response');
                                // }
                                
                                $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));

                                //Updating Cron date
                                $this->db->set('previous_sell_price',$erp['sell_price']);
                                $this->db->set('updated_on_cron',date('Y-m-d'));
                                $this->db->where('id',$erp['id']);
                                $this->db->update('erp_response');
                            }
                        }
                        catch (ShopifyApiException $e)
                        {
                            // pre($e);exit();
                        }
                    }
                    // echo "<pre>";print_r($variant_data);
                }
            }
        }
        else
        {
            $this->db->set('updated_on_cron',date('0000-00-00'));
            $this->db->update('erp_response');
        } 
    }
    
    public function updateProducts()
    {

        $shop = "65994c.myshopify.com";
        $getStore = $this->home->getStore($shop);
        $token = $getStore->token;

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);

        $this->load->library('shopifyapi', $params);


        // $this->db->select('erp_response.*');
        $this->db->select('*');
        $this->db->from('erp_response');
        $this->db->where('updated_on_cron !=', date("Y-m-d"));
        // $this->db->join('products', 'erp_response.item_code = products.item_barcode', 'inner');
        $q = $this->db->get();
        $result = $q->result_array();
        // echo date('Y-m-d');die;
        // echo "<pre>";print_r($result);exit;
        if(!empty($result)) 
        {
            foreach($result as $erp)    
            {
                $where = 'products.'."item_barcode = '".$erp['item_code']."'";
                $product = $this->home->getRowByWhere('products',$where);
                
                // echo "<pre>";print_r($product);
                
                if(!empty($product))
                {
                        $date_update = 0;    
                        if(number_format((float)$erp['sell_price'], 2, '.', '') != number_format((float)$erp['previous_sell_price'], 2, '.', ''))
                        {
                            /* PRODUCT PRICE WILL UPDATE */
                            
                            $date_update = $date_update + 1;

                            $product_array = array(
                        
                                "variant" => array(
    
                                    "id" => $product->variant_id,
                                    "price" =>  number_format((float)$erp['sell_price'], 2, '.', '')
                                    )
                            );
                            // echo "<pre>";print_r($product_array);
                            try {
    
                                $update = $this->shopifyapi->call('PUT', '/admin/api/2023-04/variants/'.$product->variant_id.'.json',$product_array);
                                
                                // print_r($update);

                                if($update)
                                {
                                	/*Updating previous sell price & cron date*/
	                                $this->db->set('previous_sell_price',$erp['sell_price']);
	                                $this->db->set('updated_on_cron',date('Y-m-d'));
	                                $this->db->where('id',$erp['id']);
	                                $this->db->update('erp_response');
                                }
    
                            }
                            catch (ShopifyApiException $e)
                            {
                                // pre($e);exit();
                            }
                            
                        }
                        if(number_format((float)$erp['compare_price'], 2, '.', '') != number_format((float)$erp['previous_compare_price'], 2, '.', ''))
                        {
                        	/* COST PRICE WILL UPDATE */

                        	$date_update = $date_update + 1;

                        	$product_array1 = array(
                        
                                "variant" => array(
    
                                    "id" => $product->variant_id,
                                    "cost" => number_format((float)$erp['compare_price'], 2, '.', '')
                                    )
                            );
                            // echo "<pre>";print_r($product_array1);
                            try {
    
                                $cost_update = $this->shopifyapi->call('PUT', '/admin/api/2023-04/variants/'.$product->variant_id.'.json',$product_array1);

                                // print_r($cost_update);

                                if($cost_update)
                                {
                                	/*Updating previous compare price & cron date*/
	                                $this->db->set('previous_compare_price',$erp['compare_price']);
	                                $this->db->set('updated_on_cron',date('Y-m-d'));
	                                $this->db->where('id',$erp['id']);
	                                $this->db->update('erp_response');
                                }
    
                            }
                            catch (ShopifyApiException $e)
                            {
                                // pre($e);exit();
                            }

                        }
                        if(intval($erp['previous_quantity']) != intval($erp['quantity']))
                        {
                        	$date_update = $date_update + 1;
                        	
                        	$quantity_array = array(
    
                                    "available" => intval($erp['quantity']),
                                    "inventory_item_id" => $product->inventory_item_id,
                                    "location_id" => 84926988596
                                    
                            );
                            // echo "<pre>";print_r($quantity_array);
                            try {
    
                                $quantity_update = $this->shopifyapi->call('POST', '/admin/api/2023-04/inventory_levels/set.json',$quantity_array);

                                // print_r($quantity_update);

                                if($quantity_update)
                                {
                                	/*Updating previous quantity & cron date*/
                                    $this->db->set('previous_quantity',$erp['quantity']);
                                    $this->db->set('updated_on_cron',date('Y-m-d'));
                                    $this->db->where('id',$erp['id']);
                                    $this->db->update('erp_response');
                                }
    
                            }
                            catch (ShopifyApiException $e)
                            {
                                // pre($e);exit();
                            }

                            /** $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));
                            
                            //update previuos qty and cron date
                            $this->db->set('previous_quantity',$erp['quantity']);
                            $this->db->set('updated_on_cron',date('Y-m-d'));
                            $this->db->where('id',$erp['id']);
                            $this->db->update('erp_response'); **/

                        }

                        /* Updating cron date */
                        // if($date_update == 0)
                        // {
                        	$this->db->set('updated_on_cron',date('Y-m-d'));
                            $this->db->where('id',$erp['id']);
                            $this->db->update('erp_response');
                        // }
                }
                else
                {
                    $this->db->set('updated_on_cron',date('Y-m-d'));
                    $this->db->where('id',$erp['id']);
                    $this->db->update('erp_response');
                }
            }
        }
        else
        {
            // echo "OUTTT";
            $this->db->set('updated_on_cron',date('0000-00-00'));
            $this->db->update('erp_response');
        } 
    }
    
    public function updateProductsDesc()
    {
        $shop = "65994c.myshopify.com";
        $getStore = $this->home->getStore($shop);
        $token = $getStore->token;

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);

        $this->load->library('shopifyapi', $params);


        $this->db->select('erp_response.*');
        $this->db->from('erp_response');
        $this->db->where('updated_on_cron !=', date("Y-m-d"));
        $this->db->join('products', 'erp_response.item_code = products.item_barcode', 'inner');
        $this->db->order_by("erp_response.id", "desc");
        $q = $this->db->get();
        $result = $q->result_array();
        // echo date('Y-m-d');die;
        // echo "<pre>";print_r($result);exit;
        
        if(!empty($result)) 
        {
            foreach($result as $erp)    
            {
                $where = 'products.'."item_barcode = '".$erp['item_code']."'";
                $product = $this->home->getRowByWhere('products',$where);
                
                if(!empty($product))
                {
                    // echo "<pre>";print_r($erp['item_code']);
                    // echo "<pre>";print_r($product);
                    // echo "<pre>";print_r(intval($erp['quantity']));
                    // echo "<pre>";print_r(number_format((float)$erp['sell_price'], 2, '.', ''));
                    // echo "<pre>";print_r(number_format((float)$erp['compare_price'], 2, '.', ''));
                        
                    if(number_format((float)$erp['sell_price'], 2, '.', '') == number_format((float)$erp['previous_sell_price'], 2, '.', ''))
                    {
                        // echo "PRICES ARE SAME";
                        
                        // if(intval($erp['previous_quantity']) != intval($erp['quantity']))
                        // {
                        //     $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));
                            
                        //     //update previuos qty and cron date
                        //     $this->db->set('previous_quantity',$erp['quantity']);
                        //     $this->db->set('updated_on_cron',date('Y-m-d'));
                        //     $this->db->where('id',$erp['id']);
                        //     $this->db->update('erp_response');
                        // }
                        $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));
                        
                        //update previuos qty and cron date
                            // $this->db->set('previous_quantity',$erp['quantity']);
                        $this->db->set('updated_on_cron',date('Y-m-d'));
                        $this->db->where('id',$erp['id']);
                        $this->db->update('erp_response');
                    }
                    else
                    {
                        // echo "PRICES ARE NOT SAME";
                            // echo "<pre>";print_r($product->variant_id);
                        
                            // echo "<pre>";print_r(number_format((float)$erp['sell_price'], 2, '.', ''));
                            
                            // echo "<pre>";print_r($variant_data['price']);
                            
                        $product_array = array(
                    
                            "variant" => array(

                                "id" => $product->variant_id,
                                "price" =>  number_format((float)$erp['sell_price'], 2, '.', ''),
                                "cost" => number_format((float)$erp['compare_price'], 2, '.', '')
                                )
                        );
                        // echo "<pre>";print_r($product_array);die;
                        try {

                            $update = $this->shopifyapi->call('PUT', '/admin/api/2023-10/variants/'.$product->variant_id.'.json',$product_array);

                            if($update)
                            {
                                // if(intval($erp['previous_quantity']) != intval($erp['quantity']))
                                // {
                                //     $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));
                                    
                                //     //update previuos qty and cron date
                                //     $this->db->set('previous_quantity',$erp['quantity']);
                                //     $this->db->where('id',$erp['id']);
                                //     $this->db->update('erp_response');
                                // }
                                
                                $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));

                                //Updating Cron date
                                $this->db->set('previous_sell_price',$erp['sell_price']);
                                $this->db->set('updated_on_cron',date('Y-m-d'));
                                $this->db->where('id',$erp['id']);
                                $this->db->update('erp_response');
                            }
                        }
                        catch (ShopifyApiException $e)
                        {
                            // pre($e);exit();
                        }
                    }
                    // echo "<pre>";print_r($variant_data);
                }
            }
        }
        else
        {
            // $this->db->set('updated_on_cron',date('0000-00-00'));
            // $this->db->update('erp_response');
        }
    }
    
    public function newUpdateProducts($item_code = null)
    {

        if(!empty($item_code))
        {

            $shop = "65994c.myshopify.com";
            $getStore = $this->home->getStore($shop);
            $token = $getStore->token;
    
            $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);
    
            $this->load->library('shopifyapi', $params);
    
    
            $this->db->select('erp_response.*');
            $this->db->from('erp_response');
            $this->db->join('products', 'erp_response.item_code = products.item_barcode', 'inner');
            $this->db->where('erp_response.item_code', $item_code);
            $q = $this->db->get();
            $result = $q->result_array();
            // echo date('Y-m-d');die;
            // echo "<pre>";print_r($result);exit;
            if(!empty($result)) 
            {
                foreach($result as $erp)    
                {
                    $where = 'products.'."item_barcode = '".$erp['item_code']."'";
                    $product = $this->home->getRowByWhere('products',$where);
                    
                    if(!empty($product))
                    {
                        $date_update = 0;    
                        // if(number_format((float)$erp['sell_price'], 2, '.', '') != number_format((float)$erp['previous_sell_price'], 2, '.', ''))
                        // {
                            /* PRODUCT PRICE WILL UPDATE */
                            
                            // $date_update = $date_update + 1;

                            $product_array = array(
                        
                                "variant" => array(
    
                                    "id" => $product->variant_id,
                                    "price" =>  number_format((float)$erp['sell_price'], 2, '.', '')
                                    )
                            );
                            // echo "<pre>";print_r($product_array);die;
                            try {
    
                                $update = $this->shopifyapi->call('PUT', '/admin/api/2023-04/variants/'.$product->variant_id.'.json',$product_array);

                                if($update)
                                {
                                	/*Updating previous sell price & cron date*/
	                                $this->db->set('previous_sell_price',$erp['sell_price']);
	                                $this->db->set('updated_on_cron',date('Y-m-d'));
	                                $this->db->where('id',$erp['id']);
	                                $this->db->update('erp_response');
                                }
    
                            }
                            catch (ShopifyApiException $e)
                            {
                                // pre($e);exit();
                            }
                            
                            // echo "PRODUCT PRICE HAS BEEN UPDATED FOR ITEM CODE".$item_code;
                        // }
                        
                        // if(number_format((float)$erp['compare_price'], 2, '.', '') != number_format((float)$erp['previous_compare_price'], 2, '.', ''))
                        // {
                        	/* COST PRICE WILL UPDATE */

                        // 	$date_update = $date_update + 1;

                        	$product_array1 = array(
                        
                                "variant" => array(
    
                                    "id" => $product->variant_id,
                                    "cost" => number_format((float)$erp['compare_price'], 2, '.', '')
                                    )
                            );
                            // echo "<pre>";print_r($product_array);die;
                            try {
    
                                $cost_update = $this->shopifyapi->call('PUT', '/admin/api/2023-04/variants/'.$product->variant_id.'.json',$product_array1);

                                if($cost_update)
                                {
                                	/*Updating previous compare price & cron date*/
	                                $this->db->set('previous_compare_price',$erp['compare_price']);
	                                $this->db->set('updated_on_cron',date('Y-m-d'));
	                                $this->db->where('id',$erp['id']);
	                                $this->db->update('erp_response');
                                }
    
                            }
                            catch (ShopifyApiException $e)
                            {
                                // pre($e);exit();
                            }
                            
                            // echo "<br>COST PRICE HAS BEEN UPDATED FOR ITEM CODE".$item_code;
                        // }
                        
                        // if(intval($erp['previous_quantity']) != intval($erp['quantity']))
                        // {
                        	
                            $quantity_array = array(
    
                                    "available" => intval($erp['quantity']),
                                    "inventory_item_id" => $product->inventory_item_id,
                                    "location_id" => 84926988596
                                    
                            );
                            // echo "<pre>";print_r($quantity_array);
                            try {
    
                                $quantity_update = $this->shopifyapi->call('POST', '/admin/api/2023-04/inventory_levels/set.json',$quantity_array);

                                // print_r($quantity_update);

                                if($quantity_update)
                                {
                                	/*Updating previous quantity & cron date*/
                                    $this->db->set('previous_quantity',$erp['quantity']);
                                    $this->db->set('updated_on_cron',date('Y-m-d'));
                                    $this->db->where('id',$erp['id']);
                                    $this->db->update('erp_response');
                                }
    
                            }
                            catch (ShopifyApiException $e)
                            {
                                // pre($e);exit();
                            }

                            // $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));
                            
                            // //update previuos qty and cron date
                            // $this->db->set('previous_quantity',$erp['quantity']);
                            // $this->db->set('updated_on_cron',date('Y-m-d'));
                            // $this->db->where('id',$erp['id']);
                            // $this->db->update('erp_response');

                            // echo "<br>QUANTITY PRICE HAS BEEN UPDATED FOR ITEM CODE".$item_code;
                        // }
                        
                        echo "ITEM CODE HAS BEEN UPDATED: ".$item_code;

                        /* Updating cron date */
                        // if($date_update == 0)
                        // {
                        // 	$this->db->set('updated_on_cron',date('Y-m-d'));
                        //     $this->db->where('id',$erp['id']);
                        //     $this->db->update('erp_response');
                        // }
                    }
                }
            }
            else
            {
                echo "INCORRECT ITEM CODE";
            }
        }
        else
        {
            echo "ENTER ITEM CODE";
        }
    }
   
    public function update_inventory($location_id,$inventory_item_id,$available)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://65994c.myshopify.com/admin/api/2023-01/inventory_levels/set.json',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => array('location_id' => $location_id,'inventory_item_id' => $inventory_item_id,'available' => $available),
          CURLOPT_HTTPHEADER => array(
            'X-Shopify-Access-Token: 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'
          ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return true;
        // echo $response;
    }
    
    
    public function soap_to_json_test()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'http://197.44.55.68/bloom_onlinestore_ws/n_bloom_onlinestore_ws.asmx?op=f_get_items_list',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'<?xml version="1.0" encoding="utf-8"?>
        <soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
          <soap12:Body>
            <f_get_items_list xmlns="http://tempurl.org">
              <str1>
                <str_items_list>
                  <item_code>34543</item_code>
                </str_items_list>
                <str_items_list>
                  <item_code>34543</item_code>
                </str_items_list>
              </str1>
            </f_get_items_list>
          </soap12:Body>
        </soap12:Envelope>',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/soap+xml',
            'Host: 197.44.55.68',
            'User-Agent: PostmanRuntime/7.32.2',
            'Accept: */*',
            'Accept-Encoding: gzip, deflate, br',
            'Connection: keep-alive',
            'Cookie: PowerBuilder=CurrentTheme=xp'
          ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        // $xml = file_get_contents($response);
        // SimpleXML seems to have problems with the colon ":" in the <xxx:yyy> response tags, so take them out
        $xml = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $response);
        // echo "<pre>";print_r($xml);die;
        $xml = simplexml_load_string($xml);
        $json = json_encode($xml);
        $responseArray = json_decode($json,true);
        // echo "<pre>";print_r($responseArray['soapBody']['f_get_items_listResponse']['str1']['str_items_list']);die;
        $array = $responseArray['soapBody']['f_get_items_listResponse']['str1']['str_items_list'];
        

        // $this->db->select('*');
        //     $this->db->from('erp_xml_response');
        //     $this->db->where('erp_xml_response.id', 13);
        //     $q = $this->db->get();
        //     $result = $q->row_array();
        //     // echo date('Y-m-d');die;
        //     // echo "<pre>";print_r($result);
        //     // echo "<pre>";print_r(json_decode($result['json_data']));exit;

        // // echo "<pre>";print_r($array);die;
            
        // $array = json_decode($result['json_data'], true);

        for ($i=0; $i < sizeof($array); $i++) 
        { 
            // echo "<pre>";print_r($array[$i]);

            // $where = 'erp_response.'."item_barcode = '".$array[$i]['item_international_barcode']."'";
            
            $where = 'erp_response.'."item_code = '".intval($array[$i]['item_code'])."'";

            $dataExists=$this->home->getRowByWhere('erp_response',$where);

            // echo "<pre>";print_r($dataExists);

            if($dataExists)
            {
                echo "EXISTS";
                echo "<pre>";print_r($array[$i]);
                echo "<pre>";print_r($dataExists);    
                
                $data3 = array(

                'item_code'  => $array[$i]['item_code'],
                'item_barcode'  => $array[$i]['item_international_barcode'],
                'quantity' => $array[$i]['item_total_balance_qty'],
                'previous_quantity' => $dataExists->previous_quantity,
                'sell_price' => $array[$i]['item_enduser_sellprice'],
                'previous_sell_price' => $dataExists->previous_sell_price,
                'compare_price' => $array[$i]['item_unit_cost'],
                'previous_compare_price' => $dataExists->previous_compare_price
                );
                
                $where1 = 'erp_response.'."item_code = '".$array[$i]['item_code']."'";
                $update = $this->home->update('erp_response',$data3,$where1);

                echo $update; 

            }
            else
            {
                
                echo "NEW";
                echo "<pre>";print_r($array[$i]);
                
                $data1 = array(

                'item_code'  => $array[$i]['item_code'],
                'item_barcode'  => $array[$i]['item_international_barcode'],
                'quantity' => $array[$i]['item_total_balance_qty'],
                'previous_quantity' => $array[$i]['item_total_balance_qty'],
                'sell_price' => $array[$i]['item_enduser_sellprice'],
                'previous_sell_price' => 0,
                'compare_price' => $array[$i]['item_unit_cost'],
                'previous_compare_price' => 0
                );
                
                $insert = $this->home->insert('erp_response',$data1);

                echo $insert;
            }
        }
    }

}
