<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
header('Access-Control-Allow-Origin: *');
class Homepage extends CI_Controller {

    function __construct(){
        ini_set('display_errors', 1);
        parent::__construct();
        $this->load->library('session','form_validation');
        $this->load->helper('url');
        $this->load->helper('form');
        $this->load->helper('file');
        $this->load->helper('download');
        $this->load->model('homem', 'home');
    }

    public function index()
    {	
        echo "Welcome to Bloom Pharmacy Custom App";die;
    }

    public function soap_to_json()
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'http://197.44.55.68/bloom_onlinestore_ws/n_bloom_onlinestore_ws.asmx?op=f_get_items_list',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'<?xml version="1.0" encoding="utf-8"?>
        <soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
          <soap12:Body>
            <f_get_items_list xmlns="http://tempurl.org">
              <str1>
                <str_items_list>
                  <item_code>34543</item_code>
                </str_items_list>
                <str_items_list>
                  <item_code>34543</item_code>
                </str_items_list>
              </str1>
            </f_get_items_list>
          </soap12:Body>
        </soap12:Envelope>',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/soap+xml',
            'Host: 197.44.55.68',
            'User-Agent: PostmanRuntime/7.32.2',
            'Accept: */*',
            'Accept-Encoding: gzip, deflate, br',
            'Connection: keep-alive',
            'Cookie: PowerBuilder=CurrentTheme=xp'
          ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        // $xml = file_get_contents($response);
        // SimpleXML seems to have problems with the colon ":" in the <xxx:yyy> response tags, so take them out
        $xml = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $response);
        // echo "<pre>";print_r($xml);die;
        $xml = simplexml_load_string($xml);
        $json = json_encode($xml);
        $responseArray = json_decode($json,true);
        // echo "<pre>";print_r($responseArray['soapBody']['f_get_items_listResponse']['str1']['str_items_list']);die;
        $array = $responseArray['soapBody']['f_get_items_listResponse']['str1']['str_items_list'];

        for ($i=0; $i < sizeof($array); $i++) 
        { 
            // echo "<pre>";print_r($array[$i]);
            $data1 = array(

                'item_code'  => $array[$i]['item_code'],
                'item_barcode'  => $array[$i]['item_international_barcode'],
                'quantity' => $array[$i]['item_total_balance_qty'],
                'sell_price' => $array[$i]['item_enduser_sellprice'],
                'compare_price' => $array[$i]['item_unit_cost']
            );  

            $where = 'erp_response.'."item_barcode = '".$array[$i]['item_international_barcode']."'";

            $dataExists=$this->home->getRowByWhere('erp_response',$where);

            // echo "<pre>";print_r($dataExists);

            if($dataExists)
            {
                $where1 = 'erp_response.'."item_barcode = '".$array[$i]['item_international_barcode']."'";
                $update = $this->home->update('erp_response',$data1,$where1);

                echo $update; 

            }
            else
            {
                $insert = $this->home->insert('erp_response',$data1);

                echo $insert;
            }
        }
    }
    
    
    public function insertProducts()
    {
        $shop = "65994c.myshopify.com";
        $getStore = $this->home->getStore($shop);
        $token = $getStore->token;

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);

        $this->load->library('shopifyapi', $params);

        try {
            $product_count = $this->shopifyapi->call('GET', '/admin/api/2023-01/products/count.json');
                   
                if ($product_count > 0) {
                    $all_products = [];
                    $last_id = '';
                    do {
                        $products = $this->shopifyapi->call('GET', '/admin/api/2023-01/products.json?limit=250&since_id='.$last_id.'&order=id%20asc');
                        $all_products = array_merge($all_products, $products);
                        if (count($products)>0) {
                            $last_product_id = end($products);
                            $last_id = $last_product_id['id'];
                        }
                        
                    } while (!empty($products));
                
                }
                
            } catch (ShopifyApiException $e) {
                // pre($e);exit;
            }
    
        // echo "<pre>";print_r($all_products);die;
        foreach($all_products as $product)
        {
            echo "<pre>";print_r($product['title']);
            for($i = 0; $i < sizeof($product['variants']); $i++)
            {
                $data1 = array(

                    'product_id'  => $product['id'],
                    'variant_id'  => $product['variants'][$i]['id'],
                    'inventory_item_id' => $product['variants'][$i]['inventory_item_id'],
                    'item_barcode' => $product['variants'][$i]['barcode']
                );  

                $where = 'products.'."variant_id = '".$product['variants'][$i]['id']."'";

                $dataExists=$this->home->getRowByWhere('products',$where);

                // echo "<pre>";print_r($dataExists);

                if($dataExists)
                {
                    $where1 = 'products.'."variant_id = '".$product['variants'][$i]['id']."'";
                    $update = $this->home->update('products',$data1,$where1);

                    echo $update; 

                }
                else
                {
                    $insert = $this->home->insert('products',$data1);

                    echo $insert;
                }

            }
        }
    }
    
    public function insertLatestProducts()
    {
        $shop = "65994c.myshopify.com";
        $getStore = $this->home->getStore($shop);
        $token = $getStore->token;

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);

        $this->load->library('shopifyapi', $params);

        try {
            $product_count = $this->shopifyapi->call('GET', '/admin/api/2023-01/products/count.json');
                   
                if ($product_count > 0) {
                    $all_products = [];
                    $last_id = '';
                    do {
                        $products = $this->shopifyapi->call('GET', '/admin/api/2023-01/products.json?limit=250&since_id='.$last_id.'&order=id%20desc');
                        $all_products = array_merge($all_products, $products);
                        if (count($products)>0) {
                            $last_product_id = end($products);
                            $last_id = $last_product_id['id'];
                        }
                        
                    } while (!empty($products));
                
                }
                
            } catch (ShopifyApiException $e) {
                // pre($e);exit;
            }
    
        // echo "<pre>";print_r($all_products);die;
        foreach($all_products as $product)
        {
            echo "<pre>";print_r($product['title']);
            for($i = 0; $i < sizeof($product['variants']); $i++)
            {
                $data1 = array(

                    'product_id'  => $product['id'],
                    'variant_id'  => $product['variants'][$i]['id'],
                    'inventory_item_id' => $product['variants'][$i]['inventory_item_id'],
                    'item_barcode' => $product['variants'][$i]['barcode']
                );  

                $where = 'products.'."variant_id = '".$product['variants'][$i]['id']."'";

                $dataExists=$this->home->getRowByWhere('products',$where);

                // echo "<pre>";print_r($dataExists);

                if($dataExists)
                {
                    $where1 = 'products.'."variant_id = '".$product['variants'][$i]['id']."'";
                    $update = $this->home->update('products',$data1,$where1);

                    echo $update; 

                }
                else
                {
                    $insert = $this->home->insert('products',$data1);

                    echo $insert;
                }

            }
        }
    }
    
    public function updateProducts()
    {

        $shop = "65994c.myshopify.com";
        $getStore = $this->home->getStore($shop);
        $token = $getStore->token;

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);

        $this->load->library('shopifyapi', $params);


        $this->db->select('erp_response.*');
        $this->db->from('erp_response');
        $this->db->where('updated_on_cron !=', date("Y-m-d"));
        $this->db->join('products', 'erp_response.item_code = products.item_barcode', 'inner');
        $q = $this->db->get();
        $result = $q->result_array();
        // echo date('Y-m-d');die;
        // echo "<pre>";print_r($result);exit;
        if(!empty($result)) 
        {
            foreach($result as $erp)    
            {
                $where = 'products.'."item_barcode = '".$erp['item_code']."'";
                $product = $this->home->getRowByWhere('products',$where);
                
                if(!empty($product))
                {
                    // echo "<pre>";print_r($erp['item_code']);
                    // echo "<pre>";print_r($product);
                    // echo "<pre>";print_r(intval($erp['quantity']));
                    // echo "<pre>";print_r(number_format((float)$erp['sell_price'], 2, '.', ''));
                    // echo "<pre>";print_r(number_format((float)$erp['compare_price'], 2, '.', ''));

                    $product_array = array(
                        
                            "variant" => array(

                                "id" => $product->variant_id,
                                "price" =>  number_format((float)$erp['sell_price'], 2, '.', ''),
                                "cost" => number_format((float)$erp['compare_price'], 2, '.', '')
                                )
                        );
                        // echo "<pre>";print_r($product_array);die;
                        try {

                            $update = $this->shopifyapi->call('PUT', '/admin/api/2023-04/variants/'.$product->variant_id.'.json',$product_array);

                            if($update)
                            {
                                $this->update_inventory(84926988596,$product->inventory_item_id,intval($erp['quantity']));

                                //Updating Cron date
                                $this->db->set('updated_on_cron',date('Y-m-d'));
                                $this->db->where('id',$erp['id']);
                                $this->db->update('erp_response');
                            }
                        }
                        catch (ShopifyApiException $e)
                        {
                            // pre($e);exit();
                        }
                }
            }
        }
        else
        {
            $this->db->set('updated_on_cron',date('0000-00-00'));
            $this->db->update('erp_response');
        } 
    }
    
    
    public function update_inventory($location_id,$inventory_item_id,$available)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://65994c.myshopify.com/admin/api/2023-01/inventory_levels/set.json',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => array('location_id' => $location_id,'inventory_item_id' => $inventory_item_id,'available' => $available),
          CURLOPT_HTTPHEADER => array(
            'X-Shopify-Access-Token: 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'
          ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return true;
        // echo $response;
    }
    

}
