<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Login extends CI_Controller {

    function __construct() {

        parent::__construct();
        $this->load->model('loginm', 'auth');
    }

    public function index() {
        if ($this->input->get('code')) {
            
            $code = $this->input->get('code');
            $shop = $this->input->get('shop');
            $params = array('shop_domain' => $shop, 'token' => '', 'api_key' => API_KEY, 'secret' => SECRET);
            $this->load->library('shopifyapi', $params);
            $token = $this->shopifyapi->getAccessToken($code);
            
            if ($token != '') {

                $this->session->set_userdata('token', $token);
                $this->session->set_userdata('shop', $shop);
                $getstore = $this->auth->checkStore($shop, $token);
                
                if (!$getstore) {

                    $data = array('shop_url' => $shop, 'token' => $token, 'created_at' => date('Y:m:d H:i:s'), 'status' => 1, 'is_updated' => 1);//, 'is_updated' => 1
                    $shop_id = $this->auth->setStore($data);
                                        

                    $getstore = $this->auth->checkStore($shop, $token);
                    

                    $this->session->set_userdata('store', $getstore);
                    
                } else {
                    
                    $this->auth->UpdateToken($shop, $token, 1);
                    $getstore = $this->auth->checkStore($shop, $token);                    
                    $this->session->set_userdata('store', $getstore);
                }
                redirect('homepage');
            }
            redirect('homepage');
            exit;
        } else if ($this->input->post('shop') || ($this->input->get('shop'))) {
            
            $shop = $this->input->post('shop') ? $this->input->post('shop') : $this->input->get('shop');
            $params = array('shop_domain' => $shop, 'token' => '', 'api_key' => API_KEY, 'secret' => SECRET);
            $this->load->library('shopifyapi', $params);

            //get the URL to the current page
            $pageURL = base_url('login');
            redirect($this->shopifyapi->getAuthorizeUrl(SHOPIFY_SCOPE, $pageURL));
            exit;
        }
        $data['title'] = 'Training';
        $this->load->view('loginpage', $data);
    }
    
    function logout(){
        $this->session->sess_destroy();
        redirect('/');
    }
    
    function getcharges(){
        // redirect('homepage/checkWebhook');
        $shop = $this->session->userdata('shop');
        $token = $this->session->userdata('token');
        
        if(!$shop){
            echo 'Customer Also Bought not support your browser or <a href="http://www.macworld.co.uk/how-to/mac/how-enable-cookies-mac-3462635/" target="_blank">enable cookies</a> in your browser and try again.';
            exit;
        }
        
        $charges = $this->charges->getRecurringCharge();

        $params = array('shop_domain' => $shop, 'token' => $token, 'api_key' => API_KEY, 'secret' => SECRET);
        $this->load->library('shopifyapi', $params);
        
        $shopdata = $this->shopifyapi->call('GET', '/admin/'.SHOPIFY_API_VERSION.'/shop.json');
        $dataarray = array('name'=>$shopdata['name'], 'email'=>$shopdata['email'], 'status'=>1);
        $this->auth->updatesore($dataarray, getstore('id'));

        
        $test = true;

        if (!$charges) {

            $data = array("recurring_application_charge" =>
                array(
                    "name" => "Customer Also Bought",
                    "price" => 4.97,
                    "return_url" => base_url() . "index.php/charges",
                    "trial_days" => 30,
                    // "test" => false
                    "test" => $test
                )
            );

            try {

                $result = $this->shopifyapi->call('POST', '/admin/'.SHOPIFY_API_VERSION.'/recurring_application_charges.json', $data);

                $this->charges->setRecurringCharge($result);

                //redirect($result['confirmation_url']);
                ?>
                <script>
                window.top.location = "<?php echo $result['confirmation_url']; ?>";
                </script>
                <?php
                exit;
            } catch (ShopifyApiException $e) {
                pre($e->getResponse());exit;
            }
        } else{
            if($charges->status == 'pending'){
                //redirect($charges->confirmation_url);
                ?>
                <script>
                window.top.location = "<?php echo $charges->confirmation_url; ?>";
                </script>
                <?php
                exit;
            }
        }
        redirect('homepage');
    }
    
    
}
